﻿function initCarLocks ()

	local players = getElementsByType ( "player" )
	for k,p in ipairs(players) do
		removeElementData ( p, "cl_ownedvehicle" )
		bindKey ( p, "U", "down", doToggleLocked )
	end

	local vehicles = getElementsByType ( "vehicle" )
	for k,v in ipairs(vehicles) do
		removeElementData ( v, "cl_vehicleowner" )
		removeElementData ( v, "cl_vehiclelocked" )
		removeElementData ( v, "cl_enginestate" )
		setVehicleLocked ( v, false )
		setVehicleOverrideLights ( v, 0 )
	end
end
addEventHandler ( "onResourceStart", getResourceRootElement ( getThisResource () ), initCarLocks )
addEventHandler ( "onResourceStop", getResourceRootElement ( getThisResource () ), initCarLocks )

function cl_PlayerJoin ( )
bindKey ( source, "U", "down", doToggleLocked )

end
addEventHandler ( "onPlayerJoin", getRootElement(), cl_PlayerJoin )

function cl_PlayerQuit ( )

	local ownedVehicle = getElementData ( source, "cl_ownedvehicle" )
	if (ownedVehicle ~= false) then
		cl_RemoveVehicleOwner ( ownedVehicle )
	end
end
addEventHandler ( "onPlayerQuit", getRootElement(), cl_PlayerQuit )

function cl_PlayerWasted ( )

	local ownedVehicle = getElementData ( source, "cl_ownedvehicle" )
	if (ownedVehicle ~= false) then
		cl_RemoveVehicleOwner ( ownedVehicle )
	end
end
addEventHandler ( "onPlayerWasted", getRootElement(), cl_PlayerWasted )


function cl_VehicleStartEnter ( enteringPlayer, seat, jacked )
	local theVehicle = source
	local theOwner

	if ( getElementData ( theVehicle, "cl_vehiclelocked" ) == true ) then
		theOwner = getElementData ( theVehicle, "cl_vehicleowner" )
		if theOwner ~= false and theOwner ~= enteringPlayer then

		end
	 end
end
addEventHandler ( "onVehicleStartEnter", getRootElement(), cl_VehicleStartEnter )

function cl_PlayerDriveVehicle ( player, seat, jacked )

	if ( seat == 0 ) then
		oldVehicle = getElementData ( player, "cl_ownedvehicle" )

		if ( (cl_VehicleLocked(source) == true) and (cl_VehicleOwner(source) ~= player) ) then
			removePlayerFromVehicle( player )
			Err_Msg("this vehicle is locked.", player)
			return false
		end

		cl_SetVehicleOwner ( source, player )
	end
	return true
end
addEventHandler ( "onVehicleEnter", getRootElement(), cl_PlayerDriveVehicle )

function cl_VehicleRespawn ( exploded ) 
	cl_RemoveVehicleOwner ( source )
end
addEventHandler ( "OnVehicleRespawn", getRootElement(), cl_VehicleRespawn )

function cl_VehicleExplode ( )
	local theOwner = getElementData ( source, "cl_vehicleowner" )
	if ( theOwner ~= false ) then
		cl_RemoveVehicleOwner ( source )
	end
end
addEventHandler ( "onVehicleExplode", getRootElement(), cl_VehicleExplode )

function cl_SetVehicleOwner ( theVehicle, thePlayer )
	local oldVehicle = getElementData ( thePlayer, "cl_ownedvehicle" )
	if ( oldVehicle ~= false ) then

		removeElementData ( oldVehicle, "cl_vehicleowner" )
		removeElementData ( oldVehicle, "cl_vehiclelocked" )
		removeElementData ( oldVehicle, "cl_enginestate" )
		setVehicleLocked ( oldVehicle, false ) 

	end
	setElementData ( theVehicle, "cl_vehicleowner", thePlayer )
	setElementData ( theVehicle, "cl_vehiclelocked", false )
	setElementData ( thePlayer, "cl_ownedvehicle", theVehicle )
	setElementData( theVehicle, "cl_enginestate", true )

end

function cl_RemoveVehicleOwner ( theVehicle )
	local theOwner = getElementData ( theVehicle, "cl_vehicleowner" )
	if ( theOwner ~= false ) then
		removeElementData ( theOwner, "cl_ownedvehicle" )
		removeElementData ( theVehicle, "cl_vehicleowner" )
		removeElementData ( theVehicle, "cl_vehiclelocked" )
		removeElementData ( owned, "cl_enginestate" )
	end
	setVehicleLocked ( theVehicle, false )

end

function cl_FlashLights ( thePlayer )
	setTimer ( doToggleLights, 300, 4, thePlayer, true )
end

function cl_FlashOnce ( thePlayer )
	setTimer ( doToggleLights, 300, 2, thePlayer, true )
end

function cl_VehicleOwner ( theVehicle )
	return getElementData( theVehicle, "cl_vehicleowner" )

end

function cl_VehicleLocked ( theVehicle )
	return getElementData( theVehicle, "cl_vehiclelocked" )
end

function Err_Msg ( strout, thePlayer )
	outputChatBox ( strout, thePlayer, 200, 0, 10 )
end

function Car_Msg ( strout, theVehicle )
	numseats = getVehicleMaxPassengers ( theVehicle )
	for s = 0, numseats do
		local targetPlayer = getVehicleOccupant ( theVehicle, s )
		if targetPlayer ~= false then
			outputChatBox ( strout, targetPlayer, 30, 144, 255 )
		end
	end
end

function Info_Msg ( strout, thePlayer )
	outputChatBox ( strout, thePlayer, 102, 205, 170 )
end


function doToggleLocked ( source )
	local theVehicle , strout
	if ( getElementType(source) == "vehicle" ) then
		theVehicle = source
	end
	if ( getElementType(source) == "player" ) then
		theVehicle = getElementData ( source, "cl_ownedvehicle" )
	end

	if ( theVehicle ) then
		local vehiclename = getVehicleName ( theVehicle )

		if ( getElementData ( theVehicle, "cl_vehiclelocked") == true ) then
			doUnlockVehicle ( source )
		else 
			doLockVehicle ( source )
		end
	else
		Err_Msg("Вы еще не сели в транспорт!", source)
	end
end	

function doLockVehicle ( source )
	local theVehicle , strout
	if ( getElementType(source) == "vehicle" ) then
		theVehicle = source
	end
	if ( getElementType(source) == "player" ) then
		theVehicle = getElementData ( source, "cl_ownedvehicle" )
	end

	if ( theVehicle ) then
		local vehiclename = getVehicleName ( theVehicle )

		if ( getElementData ( theVehicle, "cl_vehiclelocked") == true ) then
			strout = "Транспорт " .. vehiclename .. " закрыт!" 
			Err_Msg(strout, source)
		else 
			setElementData ( theVehicle, "cl_vehiclelocked", true)
			setVehicleLocked ( theVehicle, true ) 
			Car_Msg( "Транспорт закрыт!", theVehicle)
			Info_Msg ( "Транспорт был закрыт", source )
			if ( getVehicleController ( theVehicle ) == false ) then
				cl_FlashLights ( source )
			end
		end
	else
		Err_Msg("Вы еще не сели в транспорт!", source)
	end
end

function doUnlockVehicle ( source )
	local theVehicle, strout
	if ( getElementType(source) == "vehicle" ) then
		theVehicle = source
	end
	if ( getElementType(source) == "player" ) then
		theVehicle = getElementData ( source, "cl_ownedvehicle" )
	end
	if ( theVehicle ) then
	local vehiclename = getVehicleName ( theVehicle )
		if ( getElementData ( theVehicle, "cl_vehiclelocked") == false ) then
			strout = "Транспорт открыт!"
			Err_Msg(strout, source)
		else
			setElementData ( theVehicle, "cl_vehiclelocked", false)
			setVehicleLocked ( theVehicle, false )
			Car_Msg( "Транспорт открыт!", theVehicle )
			Info_Msg ( "Транспорт был открыт", source )
			if ( getVehicleController ( theVehicle ) == false ) then
				cl_FlashOnce ( source )
			end
		end
	else
		Err_Msg("Вы еще не сели в транспорт", source)
	end
end

function doToggleLights ( source, beep )
	local theVehicle 
	if ( getElementType(source) == "vehicle" ) then
		theVehicle = source
	end
	if ( getElementType(source) == "player" ) then
		theVehicle = getElementData ( source, "cl_ownedvehicle" )
	end
	if ( theVehicle ) then

		if ( getVehicleOverrideLights ( theVehicle ) ~= 2 ) then
            setVehicleOverrideLights ( theVehicle, 2 )

			if ( beep == true ) then
				local theElement = theVehicle
				triggerClientEvent ( getRootElement(), "onPlaySoundNearElement", getRootElement(), theElement, 5)
			end
        else
            setVehicleOverrideLights ( theVehicle, 1 )
        end
	else
		Err_Msg("Вы еще не сели в транспорт", source )
    end
end

function doToggleEngine ( source )
	local theVehicle
	if ( getElementType(source) == "vehicle" ) then
		theVehicle = source
	end
	if ( getElementType(source) == "player" ) then
		theVehicle = getElementData ( source, "cl_ownedvehicle" )
	end
	if ( theVehicle ) then

		local lights = getVehicleOverrideLights ( theVehicle )
		if ( getElementData( theVehicle, "cl_enginestate" ) == false )  then
			setElementData( theVehicle, "cl_enginestate", true)
			setVehicleEngineState( theVehicle, true )
		else
			setElementData( theVehicle, "cl_enginestate", false )
			setVehicleEngineState( theVehicle, false )
		end
		setVehicleOverrideLights ( theVehicle, lights )
	else
		Err_Msg("Вы еще не сели в транспорт!", source )
	end
end

addCommandHandler ( "mot332", doToggleEngine )
addCommandHandler ( "mot333", doToggleLights, false)
addCommandHandler ( "mot334", doLockVehicle )
addCommandHandler ( "mot335", doUnlockVehicle )