local pCuboid1 = createColCuboid(2730.1950683594, -1654.66455078125, 10, 200, 200, 30)
local pArea1 = createRadarArea( 2730, -1654, 200, 200, 238,173,14, 150 )
setElementData(pCuboid1, "friendly", "no")
setElementData(pCuboid1, "ownedBy", "Zone")
local pCuboid2 = createColCuboid(2645.1950683594, -1894.66455078125, 10, 220, 230, 30)
local pArea2 = createRadarArea( 2645, -1894, 220, 230, 238,173,14, 150 )
setElementData(pCuboid2, "friendly", "no")
setElementData(pCuboid2, "ownedBy", "Zone")
 
function getDominantTeam(col)
    local players = getElementsWithinColShape(col,'player')
    local tCount = {}
    for _,ply in ipairs(players) do
        local pTeam = getPlayerTeam(ply)
        if not tCount[pTeam] then
            tCount[pTeam] = {}
            tCount[pTeam].count = 0
            tCount[pTeam].elements = {}
        end
        tCount[pTeam].count = tCount[pTeam].count+1
        table.insert(tCount[pTeam].elements, ply)
    end
    _lastCount = 0
    _lastTeamName = false
    for team,tab in pairs(tCount) do
        local count = tab.count
        if count > _lastCount then
            _lastCount = count
            _lastTeamName = team
        elseif count == _lastCount then
            _lastCount = count
            _lastTeamName = false
        end
    end
    return _lastTeamName, _lastTeamName ~= false and tCount[_lastTeamName].elements
end
 
 
 
addEventHandler('onColShapeHit', pCuboid1,function(p)
    if (getPlayerTeam(p)) then
        if getElementType(p) ~= 'player' then return end
        local pTeam = getPlayerTeam(p)
        local iR, iG, iB = getTeamColor(pTeam)
        local rR, gG, bB = getRadarAreaColor(pArea1)
        local data = getElementData(pCuboid1, "friendly")
        if ( iR == rR ) and ( iG == gG ) and ( iB == bB ) and ( data == "yes" ) then
            outputChatBox("Вы вошли в зону пренадлежащей вашей команде",p)
        else
            outputChatBox('Вошли в зону')
            local teamName,elements = getDominantTeam(pCuboid1)
            if teamName == false then
                outputChatBox('TeamName == false')
                return
            end
            if #elements < 1 then
                outputChatBox("#elements < 2")
                return
            end
 
            for _,ply in pairs(elements) do
                outputChatBox( "Вы начали захват Территории",ply)
            end
 
 
            setRadarAreaFlashing(pArea1, true)
            capturing = setTimer(function()
                for _,ply in pairs(elements) do
                   -- givePlayerXP(ply, gameplayVariables["humanillxp"] )
                end
                setElementData(pCuboid1, "friendly", "yes")
                setElementData(pCuboid1, "ownedBy", getTeamName(pTeam))
                outputChatBox("Произошёл захват Территории")
                setRadarAreaColor( pArea1, iR, iG, iB )
                setRadarAreaFlashing( pArea1, false )
            end, 30000,1)
        end
    end
end)

addEventHandler('onColShapeLeave', pCuboid1,function(p)
    local teamName,elements = getDominantTeam(pCuboid1)
    if teamName == false or #elements < 2 then
 
        setRadarAreaFlashing( pArea1, false )
        if isTimer(capturing) then
            killTimer(capturing)
        end
 
    end
end)

addEventHandler('onColShapeHit', pCuboid2,function(p)
    if (getPlayerTeam(p)) then
        if getElementType(p) ~= 'player' then return end
        local pTeam = getPlayerTeam(p)
        local iR, iG, iB = getTeamColor(pTeam)
        local rR, gG, bB = getRadarAreaColor(pArea2)
        local data = getElementData(pCuboid2, "friendly")
        if ( iR == rR ) and ( iG == gG ) and ( iB == bB ) and ( data == "yes" ) then
            outputChatBox("Вы вошли в зону пренадлежащей вашей команде",p)
        else
            outputChatBox('Кто то вошёл в зону')
            local teamName,elements = getDominantTeam(pCuboid2)
            if teamName == false then
                outputChatBox('TeamName == false')
                return
            end
            if #elements < 1 then
                outputChatBox("#elements < 2")
                return
            end
 
            for _,ply in pairs(elements) do
                outputChatBox( "Вы начали захват Территории",ply)
            end
 
 
            setRadarAreaFlashing(pArea2, true)
            capturing = setTimer(function()
                for _,ply in pairs(elements) do
                end
                setElementData(pCuboid2, "friendly", "yes")
                setElementData(pCuboid2, "ownedBy", getTeamName(pTeam))
                outputChatBox("Произошёл захват Территории")
                setRadarAreaColor( pArea2, iR, iG, iB, 175 )
                setRadarAreaFlashing( pArea2, false )
            end, 30000,1)
        end
    end
end)

addEventHandler('onColShapeLeave', pCuboid2,function(p)
    local teamName,elements = getDominantTeam(pCuboid1)
    if teamName == false or #elements < 2 then
 
        setRadarAreaFlashing( pArea2, false )
        if isTimer(capturing) then
            killTimer(capturing)
        end
 
    end
end)