function registerElement(table, parentElement)
 
    table.__index = table
 
    table._call = function(t, ...)
 
        local ret = setmetatable({}, table)
        ret:_init(...)
        return ret
    end
 
    table = setmetatable(table, {__call = table._call})
 
    if parentElement then
 
        setmetatable(table, {__index=parentElement})
    end
 
    table.new = function(...)
 
        local ret = setmetatable({}, table)
        ret:_init(...)
        return ret
    end
end
 
_old_addEventHandler = addEventHandler
 
addEventHandler = {
   
    func = nil,
    eventName = nil,
    attachedTo = nil,
    getPropagated = nil,
    priority = nil,
 
    remove = function(self)
        self:pause()
        self = nil
    end,
 
    start = function(self)
        _old_addEventHandler(self.eventName, self.attachedTo, self.func, self.getPropagated, self.priority)
    end,
 
    pause = function(self)
        removeEventHandler(self.eventName, self.attachedTo, self.func)
    end,
 
    resume = function(self)
        self:start()
    end,
 
    _init = function(self, eventName, attachedTo, func, getPropagated, priority )
 
        self.func = func
        self.eventName = eventName
        self.attachedTo = attachedTo
        self.getPropagated = getPropagated or true
        self.priority = priority or "normal"
       
        self:start()
    end,
}
 
registerElement(addEventHandler)
