﻿ticketPrice = 10000 --Цена испытания удачи
prizePool = { -- {'Приз',шанс выигрыша в %}
	{'1 000',0.5},
	{'10 000',0.5},
	{'100 000',0.5},
	{'500 000',0.5},
	{'1 000000',100},

} 

markerSpawns = {--Места спавна маркеров (на этих маркерах открывается казино)
	--Формат - {x,y,z, размер}
	{533.28625488281,86.983695983887,21.630409240723, 8},

	{15.058104515076,23.125986099243,2.1171875, 5},

}



local mainWindow = guiCreateWindow(0.35,0.2,0.35,0.5,'Лотерея',true)
guiSetVisible(mainWindow,false)
guiWindowSetSizable(mainWindow,false)

local label_1 = guiCreateLabel(0.02,0.07,0.98,0.05,"Для участия в лотерее необходимо купить лотерейный билет",true,mainWindow)
guiLabelSetHorizontalAlign(label_1,"center")

local label_1 = guiCreateLabel(0.02,0.13,0.98,0.05,"Стоимость одного билета: "..ticketPrice.." рублей",true,mainWindow)
guiLabelSetHorizontalAlign(label_1,"center")

local memo = guiCreateMemo(0.02,0.17,0.98,0.3,"",true,mainWindow)

function buildMemoText()
	local pattern_start = "- "
	local pattern_end = " рублей"
	text = "Вы можете выиграть: \n"
	for i,k in pairs(prizePool) do
		text = text.."- "..k[1].." Рублей \n"
	end
	guiSetText(memo,text)
end
buildMemoText()


image = guiCreateStaticImage(0.25,0.37,0.47,0.55,"images/1000.png",true,mainWindow)

local closeButton = guiCreateButton(0.87,0.9,0.1,0.08,"X",true,mainWindow)
addEventHandler("onClientGUIClick",closeButton,function()
	if source ~= closeButton then return end
	guiSetVisible(mainWindow,false)
	showCursor(false)
end,false)

function buildRandomImages()
	local tab = {}
	for i=1,10 do
		local item = prizePool[math.random(#prizePool)]
		local num = string.gsub(item[1]," ","")
		local num = tonumber(num)
		table.insert(tab,'images/'..num..'.png')
	end
	return tab
end

function getRandomItem()
	local item = prizePool[math.random(#prizePool)]
	local chance = item[2]
	
	local randomNumber = math.random(0,100)+(math.random(0,100)/100)

	if randomNumber <= chance then
		local num = string.gsub(item[1]," ","")
		local num = tonumber(num)
		return num
	end
end


local startGameButton = guiCreateButton(0.15,0.9,0.6,0.08,"Испытать удачу",true,mainWindow)
addEventHandler("onClientGUIClick",startGameButton,function()
	if source ~= startGameButton then return end
	if getPlayerMoney() < ticketPrice then outputChatBox('У вас не хватает денег',255,0,0) return end
	triggerServerEvent('takeMoney',getLocalPlayer(),ticketPrice)
	guiSetEnabled(startGameButton,false)
	guiSetEnabled(closeButton,false)
	startGame()
end,false)

function startGame()
	local tab = buildRandomImages()
	prize = nil
	repeat prize = getRandomItem() until prize ~= nil
	local prizeImg = 'images/'..tostring(prize)..'.png'
	iteration = 0
	setTimer(function()
		iteration = iteration+1
		if isElement(image) then
			destroyElement(image)
			image = nil
		end
		image = guiCreateStaticImage(0.25,0.37,0.47,0.55,tab[iteration],true,mainWindow)
		if isElement(image) then
			guiSetEnabled(image,false)
		end
		if iteration == 10 then
			guiSetEnabled(startGameButton,true)
			guiSetEnabled(closeButton,true)
			outputChatBox("Вы выиграли "..prize.." Рублей",0,255,0)
			triggerServerEvent("giveMoney",getLocalPlayer(),prize)
			if prize >= 1000000 then
				triggerServerEvent('sendMessage_server',getLocalPlayer(),prize)
			end
		end
	end,500,10)
end

for _,k in ipairs(markerSpawns) do
	createBlip(k[1],k[2],k[3],25)
	local marker = createMarker(k[1],k[2],k[3],'cylinder',k[4],66,170,255,140)
	addEventHandler('onClientMarkerHit',marker,function(element,dimension)
		if element ~= getLocalPlayer() then return end
		if source ~= marker then return end
		guiSetVisible(mainWindow,true)
		showCursor(true)
	end)
end