--
-- c_main.lua
--

local picSize = Vector2(2, 5) -- scale the projected image
local picPos = Vector2(0, -0.08) -- set image center position
local picBright = false -- some vehicle do not have specular hightlighting (ie uranus) in this case set to 'true'
local mask = true -- mask vertices with position lower than element position z component
local maskHeight = -0.1 -- z position offset
local texAddress = 4 -- wrap or mirror for repeated, border for a single one

--[[
  D3DTADDRESS_WRAP         = 1,
  D3DTADDRESS_MIRROR       = 2,
  D3DTADDRESS_CLAMP        = 3,
  D3DTADDRESS_BORDER       = 4,
]]--

local enableDirt = true -- enable dirt texture
local enableEnv = true -- enable fake env texture

-- There are 2 shader effects - proj_paint_flat.fx and proj_paint_cone.fx
-- Both project the texture in a different way. For a repeated pattern 
-- that covers whole vehicle - you should use proj_paint_cone.fx
-- The current effect is adjusted for car: Infernus

local veh = nil
-- Every single entity shader needs this to be set
function passVehiclePosition()
	if veh and shader then
		local pos = veh:getPosition()
		local elFw = veh.matrix:getForward()
		local elUp = veh.matrix:getUp()
		shader:setValue('elementFwVector', elFw.x, elFw.y, elFw.z)	
		shader:setValue('elementUpVector', elUp.x, elUp.y, elUp.z)	
		shader:setValue('elementPosition', pos.x, pos.y, pos.z)	
	end
end

addEventHandler( "onClientResourceStart", getResourceRootElement(getThisResource()),
	function()

		-- Version check
		if getVersion ().sortable < "1.4.0" then
			outputChatBox( "Resource is not compatible with this client." )
			return
		end

		-- Create shader	
		shader, tec = DxShader("proj_paint_flat.fx", 0, 70, false, "vehicle")
		local texture = DxTexture("thisIsCancer.png", "dxt3")

		if not shader then
			outputChatBox( "Could not create shader. Please use debugscript 3")
		else
			outputChatBox("Using technique " .. tec)

			shader:setValue("gTextureColor", texture)
			shader:setValue("sPicSize", picSize.x, picSize.y)
			shader:setValue("sPicPos", picPos.x, picPos.y)
			shader:setValue("sPicBright", picBright)
			shader:setValue("sTexAddress", texAddress)
			shader:setValue("sMask", mask)
			shader:setValue("sMaskHeight", maskHeight)	
			shader:setValue("sEnableDirt", enableDirt)
			shader:setValue("sEnableEnv", enableEnv)

			-- if player is in vehicle
			local thisVeh = getPedOccupiedVehicle( localPlayer )
			if thisVeh then
				veh = thisVeh
				-- Apply shader
				shader:applyToWorldTexture("vehiclegrunge256", veh)
				shader:applyToWorldTexture("?emap*", veh)
				addEventHandler('onClientPreRender', root, passVehiclePosition)				
			end
		end
	end
)

addEventHandler("onClientVehicleEnter", getRootElement(),
	function(thePlayer, seat)
		if thePlayer == getLocalPlayer() then
			veh = source
			-- Apply shader
			shader:applyToWorldTexture("vehiclegrunge256", veh)
			shader:applyToWorldTexture("?emap*", veh)
			addEventHandler('onClientPreRender', root, passVehiclePosition)
		end
	end
)

addEventHandler("onClientVehicleExit", getRootElement(),
    function(thePlayer, seat)
        if thePlayer == getLocalPlayer() then
			-- Remove shader
			shader:removeFromWorldTexture("vehiclegrunge256", veh)
			shader:removeFromWorldTexture("?emap*", veh)
			veh = nil
            removeEventHandler('onClientPreRender', root, passVehiclePosition)
        end
    end
)
