function getPlayerInfraction(player)
	local acc = getPlayerAccount(player)
	if not isGuestAccount(acc) then
		return getAccountData(acc,"INF")
	else
		return 0
	end
end

function addPlayerInfraction(player,money)
	if not isGuestAccount(getPlayerAccount(player)) then
		setAccountData(getPlayerAccount(player),"INF",getAccountData(getPlayerAccount(player),"INF") + money)
		setElementData(player,"INF",getAccountData(getPlayerAccount(player),"INF"))
		return true
	else
		if getPlayerMoney(player) >= money then
			takePlayerMoney(player,money)
			return true
		else
			return false
		end
	end
end

addEventHandler("onResourceStart",resourceRoot,
	function ()
		for i,player in ipairs(getElementsByType("player")) do
			local acc = getPlayerAccount(player)
			if not isGuestAccount(acc) then
				if not getAccountData(acc,"INF") then
					setAccountData(acc,"INF",0)
					setElementData(player,"INF",0)
				else
					setElementData(player,"INF",getAccountData(acc,"INF"))
				end
			else
				setElementData(player,"INF",0)
			end
		end
	end
)

addEventHandler("onPlayerLogin",root,
	function (_,acc)
		if not getAccountData(acc,"INF") then
			setAccountData(acc,"INF",0)
			setElementData(source,"INF",0)
		else
			setElementData(source,"INF",getAccountData(acc,"INF"))
		end
	end
)

addEventHandler("onPlayerJoin",root,
	function ()
		setElementData(source,"INF",0)
		setElementData(source,"Police",false)
	end
)

addEventHandler("onPlayerLogin",root,
	function (_,acc)
		if isObjectInACLGroup("user." .. getAccountName(acc),aclGetGroup("Police")) then
			setElementData(source,"Police",true)
		end
	end
)

addEvent("onKillPlayer",true)
addEventHandler("onKillPlayer",root,
	function (player)
		if isElement(player) then
			killPed(player)
			outputChatBox("ПОЛИЦИЯ: #00ff00" .. getPlayerName(player) .. " #ff0000Был убит " .. getPlayerName(source) .. "#ff0000 .",root,255,0,0,true)
		end
	end
)

addEvent("onDestroyPlayer",true)
addEventHandler("onDestroyPlayer",root,
	function (player)
		if isElement(player) then
			local veh = getPedOccupiedVehicle(player)
			if isElement(veh) then
				destroyElement(veh)
				outputChatBox("ПОЛИЦИЯ: #00ff00" .. getPlayerName(player) .. " #ff0000Vehicle Has Been Destroyed By " .. getPlayerName(source) .. "#ff0000 .",root,255,0,0,true)
			end
		end
	end
)

addEvent("onGiveINF",true)
addEventHandler("onGiveINF",root,
	function (player,money)
		if isElement(player) then
			local did = addPlayerInfraction(player,tonumber(money))
			if did then
				outputChatBox("ПОЛИЦИЯ: #00ff00" .. getPlayerName(source) .. " #ff0000выписал вам штраф на сумму #00ff00" .. money .. "$ #ff0000 ",player,255,0,0,true)
			else
				outputChatBox("ERROR: Can't Give This Player Infraction 'NOT LOGGED IN'",source,255,0,0)
			end
		end
	end
)

addEvent("onPayAll",true)
addEventHandler("onPayAll",root,
	function ()
		if getPlayerMoney(source) >= tonumber(getElementData(source,"INF")) then
			takePlayerMoney(source,tonumber(getElementData(source,"INF")))
			setElementData(source,"INF",0)
			if not isGuestAccount(getPlayerAccount(source)) then
				setAccountData(getPlayerAccount(source),"INF",0)
			end
			outputChatBox("Все нарушения были оплачены.",source,0,255,0)
		else
			outputChatBox("Вам не хватает денег.",source,255,0,0)
		end
	end
)

addEvent("onPayThis",true)
addEventHandler("onPayThis",root,
	function (money)
		if getPlayerMoney(source) >= tonumber(money) then
			takePlayerMoney(source,money)
			setElementData(source,"INF",tonumber(getElementData(source,"INF")) - money)
			if not isGuestAccount(getPlayerAccount(source)) then
				setAccountData(getPlayerAccount(source),"INF",getElementData(source,"INF"))
			end
			outputChatBox("оплата на сумму " .. money .. "$ успешна совершена .",source,0,255,0)
		else
			outputChatBox("ERROR: You Don't Have Enough Money .",source,255,0,0)
		end
	end
)

addEventHandler("onPlayerLogin",root,
	function (_,acc)
		if isObjectInACLGroup("user." .. getAccountName(acc),aclGetGroup("Police")) then
			outputChatBox("Нажмите 'M' что бы открыть меню полиции ",source,0,255,0)
		end
	end
)

addEventHandler("onResourceStart",resourceRoot,
	function ()
		for i,player in ipairs(getElementsByType("player")) do
			if isObjectInACLGroup("user." .. getAccountName(getPlayerAccount(player)),aclGetGroup("Police")) then
				outputChatBox("Нажмите 'M' что бы открыть меню полиции",player,0,255,0)
			end
		end
	end
)

