--[[
	Name: 101ResourceReleases
	Filename: FogC.lua
	Author: Sam@ke
--]]

local classInstance = nil

FogC = {}

function FogC:constructor(parent)

	self.parent = parent
	self.screenWidth, self.screenHeight = guiGetScreenSize()
	self.fogTexture = dxCreateTexture("res/Textures/pfx_smoke_b.dds")
	
	self.size = math.random(self.screenHeight, self.screenHeight * 3)
	self.x = math.random(0 - self.size/2, self.screenWidth + self.size/2)
	self.y = math.random(0 - self.size/2, self.screenHeight + self.size/2)

	if (self.parent.coloredFog == "true") then
		self.colorR, self.colorG, self.colorB, self.colorA = math.random(90, 255), math.random(90, 255), math.random(90, 255), 25
	else
		self.colorR, self.colorG, self.colorB, self.colorA = 255, 255, 255, 25
	end
	
	self.moveSpeed = math.random(0, 100) / (500 / self.parent.fogSpeed)
	self.moveXDirection = math.random(1, 2)
	self.moveYDirection = math.random(1, 2)
	
	self.rotation = math.random(0, 360)
	self.rotSpeed = math.random(0, 50) / (600 / self.parent.fogSpeed)
	self.rotDirection = math.random(1, 2)
end

function FogC:update()
	if (self.parent.renderTarget) and (self.fogTexture) then
		if (self.rotDirection == 1) then
			self.rotation = self.rotation + self.rotSpeed
			
			if (self.rotation > 360) then
				self.rotation = 0
			end
		elseif (self.rotDirection == 2) then
			self.rotation = self.rotation - self.rotSpeed
			
			if (self.rotation < 0) then
				self.rotation = 360
			end
		end
		
		if (self.moveXDirection == 1) then
			self.x = self.x + self.moveSpeed
			
			if (self.x > self.screenWidth) then
				self.x = 0 - self.size
			end
			
		elseif (self.moveXDirection == 2) then
			self.x = self.x - self.moveSpeed
			
			if (self.x < 0 - self.size) then
				self.x = self.screenWidth + self.size
			end
		end
		
		if (self.moveYDirection == 1) then
			self.y = self.y + self.moveSpeed
			
			if (self.y > self.screenHeight) then
				self.y = 0 - self.size
			end
			
		elseif (self.moveYDirection == 2) then
			self.y = self.y - self.moveSpeed
			
			if (self.y < 0 - self.size) then
				self.y = self.screenHeight + self.size
			end
		end
		
		dxSetRenderTarget(self.parent.renderTarget, false)
		dxSetBlendMode("modulate_add")
        dxDrawImage(self.x, self.y, self.size, self.size, self.fogTexture, self.rotation, 0, 0, tocolor(self.colorR, self.colorG, self.colorB, self.colorA))
        dxSetBlendMode("blend") 
		dxSetRenderTarget()
	end
end

function FogC:destructor()

	if (self.fogTexture) then
		self.fogTexture:destroy()
		self.fogTexture = nil
	end
end