--[[
	Name: 101ResourceReleases
	Filename: CoreClassC.lua
	Author: Sam@ke
--]]

local classInstance = nil

CoreClassC = {}

function CoreClassC:constructor()
	outputChatBox("CLIENT: CoreClassC was started...")
	
	self.maxParticles = 35
	self.fogSpeed = 2.5
	self.coloredFog = "true"
	
	self.fogInstances = {}
	
	self.screenWidth, self.screenHeight = guiGetScreenSize()
	self.renderTarget = dxCreateRenderTarget(self.screenWidth, self.screenHeight)
	
	self.m_Update = function() self:update() end
	addEventHandler("onClientRender", root, self.m_Update)
	
	for i = 1, self.maxParticles, 1 do
		if (not self.fogInstances[i]) then
			self.fogInstances[i] = new(FogC, self)
		end
	end
end

function CoreClassC:update()
	if (self.renderTarget) then
		dxSetRenderTarget(self.renderTarget, true)
		
		for i = 1, self.maxParticles, 1 do
			if (self.fogInstances[i]) then
				self.fogInstances[i]:update()
			end
		end
	
		dxDrawRectangle(0, 0, self.screenWidth, self.screenHeight, tocolor(0, 0, 0, 255))
		
		dxDrawImage(0, 0, self.screenWidth, self.screenHeight, self.renderTarget)
		
		dxSetBlendMode("modulate_add")
        dxDrawText("Test Fog v1", self.screenWidth / 2, self.screenHeight / 2, self.screenWidth / 2, self.screenHeight / 2, tocolor(0, 0, 0, 45), 8, "default-bold", "center", "center")
        dxSetBlendMode("blend")
		
		dxSetRenderTarget()
	end
end

function CoreClassC:destructor()

	if (self.renderTarget) then
		self.renderTarget:destroy()
		self.renderTarget = nil
	end
	
	for i = 1, self.maxParticles, 1 do
		if (self.fogInstances[i]) then
			delete(self.fogInstances[i])
			self.fogInstances[i] = nil
		end
	end

	outputChatBox("CLIENT: CoreClassC was deleted...")
end


addEventHandler("onClientResourceStart", resourceRoot, 
function(resource)
	if (resource == getThisResource()) then
		classInstance = new(CoreClassC)
	end
end)


addEventHandler("onClientResourceStop", resourceRoot, 
function(resource)
	if (resource == getThisResource()) then
		if (classInstance) then
			delete(classInstance)
			classInstance = nil
		end
	end
end)